function[Hi_slope_p, Lo_slope_p, c_p, f_p, new_geo_p, figure_counter, c_p_H, f_p_H,...
    w_p_Man, A_p_Man, P_p_Man, R_p_Man, V_p_Man, Q_p_Man, H_p_Man, stage_p] = ...
    poolcfchoice(units,figure_counter,term_choice)

choice = 0;
while choice == 0

    if term_choice == 2
        disp(' ')
        disp('The values of c and f from the Mannings relation R=cQ^f are needed for the pool.')
        disp(' ')
        disp('1. I want to manually enter the values of values of c and f for the pool.')
        disp('2. I have the cross sectional geometry of the pool, and I need c and f calculated.')
        disp(' ')
    else
        disp(' ')
        disp('The values of c and f from the Mannings relation H=cQ^f are needed for the pool.')
        disp(' ')
        disp('1. I want to manually enter the values of values of c and f for the pool.')
        disp('2. I have the cross sectional geometry of the pool, and I need c and f calculated.')
        disp(' ')
    end
    
    choice = input('Please enter 1 or 2:  ');
    disp(' ')

    if choice ~= 1 && choice ~=2
        disp('Please enter either 1 or 2.')
        dhdx_choice = 0;
    end  %if

end  %while

if choice == 1 && term_choice == 1
    c_p_H = 0;
    f_p_H = 0;

    while c_p_H <= 0 | f_p_H <=0

        if units == 1
            disp('** IMPORTANT **')
            disp('Please ensure your calculations of c and f are in Metric units, as you previously incidated.')
        else
            disp('** IMPORTANT **')
            disp('Please ensure your calculations of c and f are in English units, as you previously incidated.')
        end

        disp(' ')
        c_p_H = input('Please enter the value of c (where H=cQ^f) for the pool:  ');
        disp(' ')
        f_p_H = input('Please enter the value of f (where H=cQ^f) for the pool:  ');
        disp(' ')

        if c_p_H <= 0 | f_p_H <= 0
            disp(' ')
            disp('Please enter positive values for c and f.')
            disp(' ')
        end  %if

    end %while

    new_geo_p = 0; c_p = 0; f_p = 0; w_p_Man = 0; A_p_Man = 0; P_p_Man = 0;
    R_p_Man = 0; V_p_Man = 0; Q_p_Man = 0; H_p_Man = 0; stage_p = 0;
    Hi_slope_p = 0; Lo_slope_p = 0;

elseif choice == 1 && term_choice == 2

    c_p = 0;
    f_p = 0;

    while c_p <= 0 | f_p <=0

        if units == 1
            disp('** IMPORTANT **')
            disp('Please ensure your calculations of c and f are in Metric units, as you previously incidated.')
        else
            disp('** IMPORTANT **')
            disp('Please ensure your calculations of c and f are in English units, as you previously incidated.')
        end

        disp(' ')
        c_p = input('Please enter the value of c (where R=cQ^f) for the pool:  ');
        disp(' ')
        f_p = input('Please enter the value of f (where R=cQ^f) for the pool:  ');
        disp(' ')

        if c_p <=0 | f_p <=0
            disp(' ')
            disp('Please enter positive values for c and f.')
            disp(' ')
        end  %if

    end %while

    new_geo_p = 0; c_p_H = 0; f_p_H = 0; w_p_Man = 0; A_p_Man = 0; P_p_Man = 0;
    R_p_Man = 0; V_p_Man = 0; Q_p_Man = 0; H_p_Man = 0; stage_p = 0;
    Hi_slope_p = 0; Lo_slope_p = 0;

elseif choice == 2
    %Get the slope for the pool
    [Hi_slope_p, Lo_slope_p] = get_slope;

    %Get the xs geo
    if units == 1
        disp(' ')
        disp('Please copy the pool''s cross-sectional geometry (in meters) into the folder in which this program runs.')
        disp(' ')
    else
        disp(' ')
        disp('Please copy the pool''s cross-sectional geometry (in feet) into the folder in which this program runs.')
        disp(' ')
    end
    xs_string_p = input('Please input the name of the text file, including the .txt extension:  ','s');
    disp(' ')
    xs_geo_p=load(xs_string_p);

    %Get the inc_p
    inc_p = 0;
    while inc_p <= 0

        %Check units
        if units == 1
            inc_p = input('Please enter the power regression stage increment (in meters) for the Manning''s calcualtion:  ');
        else
            inc_p = input('Please enter the power regression stage increment (in feet) for the Manning''s calculation:  ');
        end

        if inc_p <= 0
            disp(' ')
            disp('Please input a positive value.')
        end % if
    end % while

    %Get the mannings n
    n_p = 0;
    while n_p <= 0

        disp(' ')
        n_p = input('Please input the value of the Mannings n:  ');

        if n_p <= 0
            disp(' ')
            disp('Please input a positive value.')
        end % if

    end % while

    %Call the simpler mannings function
    [c_p,f_p,new_geo_p,figure_counter,c_p_H,f_p_H,...
        w_p_Man,A_p_Man,P_p_Man,R_p_Man,V_p_Man,Q_p_Man,H_p_Man,stage_p] = ...
        Mannings(xs_geo_p,n_p,Hi_slope_p,Lo_slope_p,inc_p,figure_counter,units);

end %big if statement